﻿
\page Úvod Úvod a zadání

\n

|  Projekt BPPC| 2012 |
|-------|---|
|autor1| Richter M | 
| | richter @ feec|
|autor2| Petyovsky P |
| | petyovsky @ feec|
|název |Ukázka doxygen|
|datum zadání| jaro |
|datum odevzdání | o rok později |

\n\n


##Zadání


###Projekt - vzor zadání

V následujícím textu je vzor zadání. 
Tučně jsou označeny prvky, které se mohou lišit obsahem, ale které platí obecně pro třídu kontejner. 
Tyto pasáže je nutné nahradit upraveným významem  pro konkrétní kontejner (normálním černým textem). 
Čím více tučných položek využijete, tím více vlastností si osvojíte a tím hodnotnější program bude. 
V tomto okamžiku nás nezajímá implementace, (tedy konkrétní realizace - názvy proměnných a jak uvnitř fungují metody), pouze u metod slovně popíšeme jak si představujeme jejich činnost. 
Poznámky v zadání nebudou, jsou pouze informativní. 
U některých tříd mohou nastat problémy s tím, že daný typ nemá pro některé metody nejlogičtější využití – zkuste si nějaké (byť méně logické) využití vymyslet (z hlediska programátorské praxe je to samozřejmě špatně, protože metody by měly být logické a snadno chápatelné, ale my zde dáme prioritu procvičení daného typu metod). 
Každý z autorů by měl napsat alespoň jednu metodu daného typu.

\n\n
###Text zadání: 

\note Místo všech názvů \c CKontejner uveďte název kontejneru zvoleného v části zadání číslo 3

\note Tučně zapsané texty nahraďte modifikací pro vaše zadání (značky pro zvýraznění bold odstraňte). Nezvýrazněný text nemažte - jedná se o povinné body zadání.

Navrhněte třídu \c __CKontejner__, která bude realizovat knihovnu pro práci s __vybraným jednoduchým (\c int, \c float ...)__ typem, který bude zapouzdřen ve třídě \c CBItem, která bude potomkem dodané třídy \c CBItemBase. 
Třída  \c CBItem bude připravena pro práci s lineárním seznamem a její využití při tvorbě seznamu je povinnou součástí projektu. Tato knihovna bude realizovat činnost s __kontejnerem__ podle následujících bodů (pokud je to možné, bude splňovat očekávané chování (podobné jako u jednoduchých typů ( \c int, \c float...))). Navržená třída __CKontejner__ umožní:

1. Třída \c CBItem zapouzdřuje datový typ: __jeden základní (\c int, \c float), jiný než \c bool__. Tuto definovanou třídu vytvoříme v jejím jmenném prostoru : \c __CBItem_bool,  \c CBItem_xxxx, \c CBItem_xxxx__. 
\note  Zde uveďte za xxxx typy zvolené pro třídy z části zadání č.1 a č.2.

2. Vznik objektu – implicitní konstruktor __který vynuluje/naplní prvky na hodnoty ...__, (konverzní) konstruktor z \c CBItem, konstruktor __z typu int (vytvářející seznam o daném počtu prvků CBItem), ...,__ konstruktor z dvojice hodnot reprezentujících __pole prvků CBItem a počet prvků, ...__ ,  konstruktort na základě C řetězce (_char *_), ve kterém budou hodnoty jednotlivých \c CBItem oddělené čárkami. Kopykonstruktor. 
\note  Celkem tedy – implicitní, kopykonstruktor, konverzní, konverzní z řetězce, s více parametry, ... – (minimální počet 6ks)
3. Počet vzniklých a aktuálních instancí třídy \c __CKontejner__ bude možné sledovat za pomoci statických proměnných třídy a bude možné je získat voláním statických metod. Každá instance třídy \c __CKontejner__ bude obsahovat privátní proměnnou \c iIndex s unikátní hodnotou sloužící k identifikaci instance (odpovídající pořadí vzniku). Hodnota této proměnné musí být přístupná mimo třídu pomocí vhodné metody - \c __VratIndex__.
4. Zánik objektu - destruktor __kontejneru__ bude implementován s mechanizmem odpočtu aktivních prvků přes statické proměnné. Dynamické členské prvky __ne/odalokuje__.
5. Budou implementovány operátory __kontejneru__ s příslušnými činnostmi:
	- operátor = __pro přiřazení,__ 
	- operátor – __jako__ unární operátor __pro inverzi kontejneru například jako: reverzace (otočení pořadí prvků), doplněk do plného kontejneru, nebo inverze jednotlivých hodnot CBItem.__
	- operátor – __jako__ binární operátor __pro rozdíl kontejnerů,__ 
	- operátor + __pro … ,__
	- operátor += __realizující a = a+b;__
	- logické operátory ==, !=, <=, > ,... __pro srovnání dvou kontejnerů (na základě obsahujících hodnot a jejich počtu).__
	- __libovolné další přetížitelné operátory__
	- __Dále__ konverzní operátor __na \c int, který bude reprezentovat počet prvků kontejneru__. 
	- Nečlenský operátor, využívající \c friend vlastností realizující __součet CBItem, \c float, \c int hodnoty a kontejneru__
\note Celkem tedy – unárních (nejméně 3ks) , binárních (nejméně 3ks), konverzní, nečlenský, logické (nejméně 3ks) – (celkem minimálně 12ks).
6. Standardní vstup a výstup z instance třídy \c __CKontejner__ bude realizován pomocí streamů (realizovaný \c friend funkcí s využitím jejích vlastností) – přetížením operátorů << a >> ve stejném formátu navrženém pro konstruktor z \c char * (tj.čárkami oddělený seznam hodnot).
7. Budou realizovány privátní a veřejné metody: veřejná metoda \c PocetPrvku pro zjištění prvků v __kontejneru__, která nebude mít parametry. Metody pro vložení a vyzvednutí prvku dle funkce __kontejneru. Dále metoda … která bude …__. Privátní metoda \c Compare, která porovná "velikost" dvou kontejnerů, kde velikost je dána počtem prvků, a vrátí hodnotu -1,0 nebo 1 (první je kratší, stejné, první je delší). Dále metoda \c CompareDeep, která porovná velikost kontejnerů i podle hodnot \c CBItem. Tyto metody budou používat logické operátory.
\note Pro privátní metody jsou nejvýhodnější funkce typu „uprav“, „přepočítej“, „zkontroluj“. Celkem tedy  – minimálně 2ks privátní a 4ks veřejné. 
8. Budou realizovány metody, pro reverzaci ( __reverzace je otočení pořadí prvků kontejneru__ ): 
	- umožňující volání \c bbb=aaa.Reverzuj(), která mění __kontejner__ \c aaa na reverzovaný __kontejner__ \c bbb, 
	- umožňující volání \c bbb=Reverzuj(aaa), která nechává __kontejner__ \c aaa nezměněn a vrací (temp objekt) reverzovaný __kontejner__. 
9. Použití dynamických dat ve třídě – __ne__předpokládám.
10. Dědění ve třídě – __ne__předpokládám.
11. Použití výjimek - __ne__předpokládám.
12. Ve vlastním projektu se předpokládá i implementace metod vytvářených překladačem implicitně.
13. Ve třídě bude pro kontrolu dat implementována knihovna Check.

\n\n
###Poznámky k řešení (jsou součástí zadání):

Odvozené třídy \c CBItem_xxxx vypracujte v projektu, kde je ve funkci main demonstrována činnost \c CBItem_bool. Po odladění je použijte ve vlastním projektu __kontejneru__, kde vytvořte v main podobný testovací kód (pro třídu kontejneru) jako je ukázáno v projektu s \c CBItem.

Vytvořená implementace __kontejneru__ musí umožňovat bezchybný překlad s libovolnou třídou \c CBItem (zapouzdřující některý z jednoduchých datových typů) bez nutnosti zásahu do zdrojových textů __kontejneru__!!!!
Implementace kontejneru tedy nebude závislá na typu ukládaných hodnot, protože bude využívat pouze definované rozhraní třídy \c CBItem (společné pro všechny typy), tak jak je uvedeno v testovacím příkladu. __CKontejner__ proto implementujte tak, aby nevyužíval ani Setter a Getter metody třídy \c CBItem, jejichž hlavička je na zapouzdřujícím typu závislá!!!

Vlastní realizace třídy pro __kontejner__ bude rozdělena na hlavičkový a zdrojový soubor. Další zdrojový soubor bude reprezentovat program demonstrující vlastnosti a použití definované třídy, který bude realizován jako konzolová aplikace přeložitelná ve Visual C++ (prázdný projekt, přísnost (stupeň) překladu 3 na detekci chybových a varovných hlášení). Soubory budou obsahovat úvodní poznámku o svém názvu, řešitelích ...). 

Tento demonstrační program bude napsán tak, aby při činnosti nevyžadoval zásahy obsluhy ani vstupní data z jiných zdrojů (s výjimkou operátoru pro standardní vstup). Demonstrační programu bude inicializovat proměnné (v něm definovanými daty nezadávanými uživatelem) a na jejich základě bude demonstrovat činnost třídy a dále zobrazovat data na konzolu, nebo ukládat výsledky do souboru.
K odevzdávanému zadání nezapomeňte připsat úvod pro hlavičku (tj. jména řešitelů, název projektu, datum zadání … budou součástí odevzdávaného souboru)

Pro lepší orientaci uvádíme krátkou motivaci k pojmu třída na adrese 
http://www.uamt.feec.vutbr.cz/~richter/vyuka/0910_ppc/bppc/cviceni/motivace_trida.html.

\n\n
Poslední změna: 2012-10-04






