#ifndef __CDATA_BOOL_H__
#define __CDATA_BOOL_H__
// Simple CData example by: Pety 2009
// $Id$

#include <iostream>
#include <sstream>

class CData
	{
	static int iTotalCounter;
	static int iLivingCounter;
	const int iIndex;

	bool iValue;
public:
// c'tors
	CData(): iIndex(iTotalCounter++), iValue(false)
		{iLivingCounter++;}
	CData(const bool aValue): iIndex(iTotalCounter++), iValue(aValue)
		{iLivingCounter++;}
	CData(const CData& aNode): iIndex(iTotalCounter++), iValue(aNode.Value())
		{iLivingCounter++;}
	CData(const char* aStr): iIndex(iTotalCounter++), iValue(false)
		{std::istringstream iss(aStr, std::istringstream::in); iss >> iValue; iLivingCounter++;}

// d'tor
	virtual ~CData()
		{iValue = false; iLivingCounter--;}

// setter, getter
	void SetValue(const bool aValue)
		{iValue = aValue;}
	bool Value() const
		{return(iValue);}

// operators
	CData operator-() const
		{return(CData(!iValue));}
	CData& operator=(const CData& aNode)
		{SetValue(aNode.Value());return(*this);}
	bool operator==(const CData& aNode) const
		{return(iValue == aNode.Value());}
	bool operator!=(const CData& aNode) const
		{return(iValue != aNode.Value());}
    bool operator<(const CData& aNode) const
		{return(iValue < aNode.Value());}
    bool operator>(const CData& aNode) const
		{return(iValue > aNode.Value());}
	
	friend std::ostream& operator<<(std::ostream& aOStream, const CData& aNode)
		{aOStream << aNode.Value(); return aOStream;}
	friend std::istream& operator>>(std::istream& aIStream, CData& aNode)
		{aIStream >> aNode.iValue; return aIStream;}

// counter getters
	static int Total()
		{return(iTotalCounter);}
	static int Living()
		{return(iLivingCounter);}
	const int Index() const 
		{return(iIndex);}
	}; /* class CData */

#endif /* __CDATA_BOOL_H__ */
